# 导入Pandas库，用于读取Excel文件
import pandas as pd
# 导入pyttsx3库，用于将文本转化为语音
import pyttsx3

# 进入无限循环，直到用户输入正确的班级编号
while True:
    # 提示用户输入要点名的班级
    classes = input('请输入要点名的班级：')

    # 判断用户输入的班级是否是'1'或者'2'
    if classes not in ['1', '2']:
        # 如果输入的不是1或2，提示用户输入错误
        print('输入错误，请输入1或者2')
        # 继续进入下一次循环，要求用户重新输入
        continue

    # 根据用户输入的班级，动态构建Excel文件的名称
    filename = f"23数技{classes}班花名册.xlsx"
    
    # 使用Pandas读取Excel文件
    df = pd.read_excel(filename)

    # 选取Excel文件中第5列的数据，并将其转换为列表
    column_data = df.iloc[:, 4].tolist()

    # 初始化语音引擎，后面用来朗读学生名字
    engine = pyttsx3.init()

    # 遍历每个学生的名字
    for i in column_data:
        # 进入一个内部循环，控制是否重复点名当前学生
        while True:
            # 打印学生名字到控制台
            print(i)
            # 使用语音引擎朗读学生名字
            engine.say(i)
            engine.runAndWait()

            # 等待用户输入，决定下一步操作
            x = input('按回车键重复点名，输入n点名下一个同学：')

            # 如果用户输入'n'，跳出当前学生的循环，点名下一个同学
            if x == 'n':
                break
            # 如果用户按了回车或其他字符，继续重复点名当前同学
            else:
                continue
